﻿Public Class Form1

    ' array to store board memory
    Dim board(2, 2) As Integer
    Dim r As New Random()

    Private Sub btnNewGame_Click(sender As Object, e As EventArgs) Handles btnNewGame.Click
        ' generate board using random numbers
        generateBoardMemory()

        ' display O and X on board
        displayBoard()

        ' display the winner
        displayWinner()
    End Sub

    ' generates and returns the random number for board
    Private Function getRandom() As Integer
        Dim randNum As Integer
        randNum = r.Next(2)

        Return randNum
    End Function

    ' generates board using random numbers
    Private Sub generateBoardMemory()
        For i As Integer = 0 To 2
            For j As Integer = 0 To 2
                board(i, j) = getRandom()
            Next
        Next
    End Sub

    ' displays O and X on board
    Private Sub displayBoard()
        For i As Integer = 0 To 2
            For j As Integer = 0 To 2

                ' find label on the board as per the position
                Dim label As Label = CType(Me.Controls("lbl" + i.ToString() + j.ToString()), Label)

                If (board(i, j) = 0) Then
                    label.Text = "O"
                Else
                    label.Text = "X"
                End If
            Next
        Next
    End Sub

    Private Sub btnExit_Click(sender As Object, e As EventArgs) Handles btnExit.Click
        Me.Close()
    End Sub

    'displays the winner
    Private Sub displayWinner()
        Dim OWon As Boolean = False
        Dim XWon As Boolean = False

        'check rows and columns
        For i As Integer = 0 To 2
            ' rows
            If ((board(i, 0) = board(i, 1)) And (board(i, 1) = board(i, 2))) Then
                If (board(i, 0) = 0) Then
                    OWon = True
                Else
                    XWon = True
                End If
            End If
            ' columns
            If ((board(0, i) = board(1, i)) And (board(1, i) = board(2, i))) Then
                If (board(0, i) = 0) Then
                    OWon = True
                Else
                    XWon = True
                End If
            End If
        Next

        ' check for left diagonal
        If ((board(0, 0) = board(1, 1)) And (board(1, 1) = board(2, 2))) Then
            If (board(0, 0) = 0) Then
                OWon = True
            Else
                XWon = True
            End If
        End If

        ' check for right diagonal
        If ((board(0, 2) = board(1, 1)) And (board(1, 1) = board(2, 0))) Then
            If (board(0, 2) = 0) Then
                OWon = True
            Else
                XWon = True
            End If
        End If

        lblWinner.BorderStyle = BorderStyle.Fixed3D

        ' now find out the winner
        If (OWon And (Not XWon)) Then
            lblWinner.Text = "O Wins!"
        ElseIf ((Not OWon) And XWon) Then
            lblWinner.Text = "X Wins!"
        Else
            lblWinner.Text = "It's a Tie!"
        End If

    End Sub

End Class
